<?php
require_once ('public/lib/print/num_letras.php');
require_once ('public/lib/pdf/cellfit.php');

class FPDF_CellFiti extends FPDF_CellFit
{
    function AutoPrint($dialog = false)
    {
        // Abre el diálogo de impresión o imprime directamente en la impresora predeterminada
        $param = ($dialog ? 'true' : 'false');
        $script = "print($param);";
        $this->IncludeJS($script);
    }

    function AutoPrintToPrinter($server, $printer, $dialog = false)
    {
        // Imprime en una impresora compartida (requiere al menos Acrobat 6)
        $script = "var pp = getPrintParams();";
        $script .= ($dialog)
            ? "pp.interactive = pp.constants.interactionLevel.full;"
            : "pp.interactive = pp.constants.interactionLevel.automatic;";
        $script .= "pp.printerName = '\\\\\\\\" . $server . "\\\\" . $printer . "';";
        $script .= "print(pp);";
        $this->IncludeJS($script);
    }
}

define('EURO', chr(128));

// ***************************************************
// Asignar valores por defecto a propiedades que puedan no existir
// ***************************************************
if (!isset($this->dato->pago_efe_none)) { 
    $this->dato->pago_efe_none = 0; 
}
if (!isset($this->dato->desc_tipo)) { 
    $this->dato->desc_tipo = 0; 
}
if (!isset($this->dato->desc_tp)) { 
    $this->dato->desc_tp = ''; 
}
if (!isset($this->dato->paga_con)) { 
    $this->dato->paga_con = 0; 
}
if (!isset($this->dato->desc_monto)) { 
    $this->dato->desc_monto = 0; 
}
if (!isset($this->dato->pago_tar)) { 
    $this->dato->pago_tar = 0; 
}
if (!isset($this->dato->pago_tran)) { 
    $this->dato->pago_tran = 0; 
}
if (!isset($this->dato->pago_yape)) { 
    $this->dato->pago_yape = 0; 
}
if (!isset($this->dato->pago_plin)) { 
    $this->dato->pago_plin = 0; 
}
if (!isset($this->dato->pago_efe)) { 
    $this->dato->pago_efe = 0; 
}
if (!isset($this->dato->comision_delivery)) { 
    $this->dato->comision_delivery = 0; 
}
if (!isset($this->dato->Config) || !is_object($this->dato->Config)) { 
    $this->dato->Config = new stdClass(); 
}
if (!isset($this->dato->Config->pedido_comanda)) { 
    $this->dato->Config->pedido_comanda = 0; 
}

// ***************************************************
// FIN: asignación de valores por defecto
// ***************************************************

$pdf = new FPDF_CellFiti('P', 'mm', array(80, 200));
$pdf->AddPage();
$pdf->SetMargins(0, 0, 0, 0);

// CABECERA
$pdf->SetFont('Helvetica', '', 6);
$pdf->Cell(72, 4, '', 0, 1, 'C');
$pdf->SetFont('Helvetica', '', 13);
$pdf->Cell(72, 4, 'DELIVERY', 0, 1, 'C');
$pdf->Ln(3);
$pdf->SetFont('Helvetica', '', 9);

// ENTREGAR FECHA/HORA DE ENTREGA
if ($this->dato->hora_entrega == Null) {
    $pdf->Cell(72, 4, 'ENTREGA: --', 0, 1, 'L');
} else {
    $pdf->Cell(72, 4, 'ENTREGA: ' . date('d-m-Y h:i A', strtotime($this->dato->hora_entrega ?? '')), 0, 1, 'L');
}





$nombreCliente = $this->dato->nombre_cliente ?? '';
$direccionCliente = $this->dato->direccion_cliente ?? '';
$referenciaCliente = $this->dato->referencia_cliente ?? '';
$dniCliente = $this->dato->dni_cliente ?? '';
$rucCliente = $this->dato->ruc_cliente ?? '';
$telefonoCliente = $this->dato->telefono_cliente ?? '';



$pdf->MultiCell(72, 4, 'CLIENTE: ' . utf8_decode($nombreCliente), 0, 1, '');
if ($this->dato->tipo_cliente == 1) {
    $pdf->Cell(72, 4, utf8_decode(Session::get('diAcr')) . ': ' . utf8_decode($dniCliente), 0, 1, '');
} else {
    $pdf->Cell(72, 4, utf8_decode(Session::get('tribAcr')) . ': ' . utf8_decode($rucCliente), 0, 1, '');
}
$pdf->MultiCell(72, 4, 'TELEFONO: ' . utf8_decode($telefonoCliente), 0, 1, '');
$pdf->MultiCell(72, 4, 'DIRECCION: ' . utf8_decode($direccionCliente), 0, 1, '');
$pdf->MultiCell(72, 4, 'REFERENCIA: ' . utf8_decode($referenciaCliente), 0, 1, '');

// COLUMNAS
$pdf->SetFont('Helvetica', 'B', 9);
$pdf->Cell(42, 10, 'PRODUCTO', 0);
$pdf->Cell(5, 10, 'CANT.', 0, 0, 'R');
$pdf->Cell(10, 10, 'P.U.', 0, 0, 'R');
$pdf->Cell(15, 10, 'IMP.', 0, 0, 'R');
$pdf->Ln(8);
$pdf->Cell(72, 0, '', 'T');
$pdf->Ln(1);

$total = 0;
foreach ($this->dato->Detalle as $d) {
    $pdf->SetFont('Helvetica', '', 9);
    $pdf->MultiCell(42, 4, utf8_decode($d->Producto->pro_nom) . ' ' . utf8_decode($d->Producto->pro_pre), 0, 'L');
    $pdf->Cell(47, -4, $d->cantidad, 0, 0, 'R');
    $pdf->Cell(10, -4, $d->precio, 0, 0, 'R');
    $pdf->Cell(15, -4, number_format(($d->cantidad * $d->precio), 2), 0, 0, 'R');
    $pdf->Ln(1);
    $total += ($d->cantidad * $d->precio);
}

$pdf->SetFont('Helvetica', '', 9);
$pdf->MultiCell(42, 4, utf8_decode('COMISIÓN DELIVERY'), 0, 'L');
$pdf->Cell(47, -4, '', 0, 0, 'R');
$pdf->Cell(10, -4, '', 0, 0, 'R');
$pdf->Cell(15, -4, number_format($this->dato->comision_delivery, 2), 0, 0, 'R');
$pdf->Ln(1);

if ($this->dato->pago_efe_none) {
    if ($this->dato->id_tpag == 1) {
        $pdf->Ln(0);
        $pdf->Cell(37, 10, 'EFECTIVO', 0);
        $pdf->Cell(20, 10, '', 0);
        $pdf->Cell(15, 10, number_format($this->dato->pago_efe, 2), 0, 0, 'R');
    } else if ($this->dato->id_tpag == 2) {
        $pdf->Ln(0);
        $pdf->Cell(37, 10, 'TARJETA', 0);
        $pdf->Cell(20, 10, '', 0);
        $pdf->Cell(15, 10, number_format($this->dato->pago_tar, 2), 0, 0, 'R');
    } else if ($this->dato->id_tpag == 3) {
        $pdf->Ln(0);
        $pdf->Cell(37, 10, 'EFECTIVO', 0);
        $pdf->Cell(20, 10, '', 0);
        $pdf->Cell(15, 10, number_format($this->dato->pago_efe, 2), 0, 0, 'R');
        if ($this->dato->pago_tar != 0) {
            $pdf->Ln(4);
            $pdf->Cell(37, 10, 'TARJETA', 0);
            $pdf->Cell(20, 10, '', 0);
            $pdf->Cell(15, 10, number_format($this->dato->pago_tar, 2), 0, 0, 'R');
        }
        if ($this->dato->pago_tran != 0) {
            $pdf->Ln(4);
            $pdf->Cell(37, 10, 'TRANSFERENCIA', 0);
            $pdf->Cell(20, 10, '', 0);
            $pdf->Cell(15, 10, number_format($this->dato->pago_tran, 2), 0, 0, 'R');
        }
        if ($this->dato->pago_yape != 0) {
            $pdf->Ln(4);
            $pdf->Cell(37, 10, 'YAPE', 0);
            $pdf->Cell(20, 10, '', 0);
            $pdf->Cell(15, 10, number_format($this->dato->pago_yape, 2), 0, 0, 'R');
        }
        if ($this->dato->pago_plin != 0) {
            $pdf->Ln(4);
            $pdf->Cell(37, 10, 'PLIN', 0);
            $pdf->Cell(20, 10, '', 0);
            $pdf->Cell(15, 10, number_format($this->dato->pago_plin, 2), 0, 0, 'R');
        }
    }
} else {
    $pdf->Ln(0);
    $pdf->Cell(37, 10, 'TOTAL', 0);
    $pdf->Cell(20, 10, '', 0);
    $pdf->Cell(15, 10, number_format($total + $this->dato->comision_delivery, 2), 0, 0, 'R');
}

// if ($this->dato->id_tpag == 1 OR $this->dato->id_tpag == 3) {
//     if ($this->dato->pago_efe_none) {
//         $pdf->Ln(8);
//         $pdf->Cell(72, 0, '', 'T');
//         $pdf->Ln(0);
//         $pdf->Cell(37, 10, 'PAGO CON', 0);
//         $pdf->Cell(20, 10, '', 0);
//         $pdf->Cell(15, 10, number_format($this->dato->pago_efe_none, 2), 0, 0, 'R');
//         $pdf->Ln(4);
//         $pdf->Cell(37, 10, 'VUELTO1', 0);
//         $pdf->Cell(20, 10, '', 0);
//         $vuelto = max(0, $this->dato->pago_efe_none - $this->dato->pago_efe);
//         $pdf->Cell(15, 10, strtoupper(number_format($vuelto, 2)), 0, 0, 'R');
//     } else {
//         $pdf->Ln(8);
//         $pdf->Cell(72, 0, '', 'T');
//         $pdf->Ln(0);
//         $pdf->Cell(37, 10, 'PAGO CON ' . $this->dato->desc_tp, 0);
//         $pdf->Cell(20, 10, '', 0);
//         $pdf->Cell(15, 10, number_format($this->dato->paga_con + $this->dato->comision_delivery, 2), 0, 0, 'R');
//         $pdf->Ln(4);
//         $pdf->Cell(37, 10, 'VUELTO2', 0);
//         $pdf->Cell(20, 10, '', 0);
//         $vuelto = max(0,  $total - $this->dato->paga_con);
//         $pdf->Cell(15, 10, strtoupper(number_format($vuelto, 2)), 0, 0, 'R');
//     }
// }

if ($this->dato->id_tpag > 3) {
    $pdf->Ln(0);
    $pdf->Cell(37, 10, 'PAGO CON', 0);
    $pdf->Cell(20, 10, '', 0);
    $pdf->Cell(15, 10, $this->dato->desc_tp, 0, 0, 'R');
}
$pdf->Ln(10);

if ($this->dato->id_tpag > 3) {
    $pdf->Ln(0);
    $pdf->Cell(37, 10, $this->dato->desc_tp, 0);
    $pdf->Cell(20, 10, '', 0);
    $pdf->Cell(15, 10, number_format($this->dato->pago_tar, 2), 0, 0, 'R');
}
if ($this->dato->desc_tipo == 1) {
    $pdf->Ln(2);
    $pdf->Cell(37, 4, 'CORTESIA', 0);
    $pdf->Cell(20, 4, '', 0, 0, 'R');
    $pdf->Cell(15, 4, '0.00', 0, 0, 'R');
}
if ($this->dato->desc_tipo == 3) {
    $pdf->Ln(2);
    $pdf->Cell(37, 4, 'CREDITO PERSONAL', 0);
    $pdf->Cell(20, 4, '', 0, 0, 'R');
    $pdf->Cell(15, 4, number_format($this->dato->desc_monto, 2), 0, 0, 'R');
}
$pdf->SetFont('Helvetica', 'B', 10);
$pdf->Cell(72, 0, '', 'T');
$pdf->Ln(1);
$pdf->Cell(37, 10, 'DELIVERY', 0);
if ($this->dato->Config->pedido_comanda == 1) {
    $pdf->Cell(37, 10, 'PED: ' . str_pad($this->dato->id_ped, 5, "0", STR_PAD_LEFT), 0);
}
$pdf->Cell(20, 10, '', 0);
$pdf->Ln(8);

$pdf->Ln(10);

$pdf->Output('ticket.pdf', 'I');
?>
