$(function() {
    moment.locale('es');
    ComboInsumoProducto(1);
    //listar();
    $('#informes').addClass("active");
    // $('#i-karval').addClass("active");

    $('#start').bootstrapMaterialDatePicker({
        format: 'DD-MM-YYYY',
        time: false,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#end').bootstrapMaterialDatePicker({
        useCurrent: false,
        format: 'DD-MM-YYYY',
        time: false,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

});

$('#start, #end, #id_ip').change( function() {
    listar();
});

$("#tipo_ip").change(function(){
    $('#id_ip').find('option').remove();
    $("#tipo_ip option:selected").each(function(){
    id_tipo_ins=$(this).val();
       $.post("inventario_ComboInsumoProducto",{id_tipo_ins: id_tipo_ins},function(data){
           $("#id_ip").html(data);
           $('#id_ip').selectpicker();
           $('#id_ip').selectpicker('refresh');
       });
    });
})

var ComboInsumoProducto = function(id_tipo_ins){
    $('#id_ip').find('option').remove();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"informe/inventario_ComboInsumoProducto",
        data: {id_tipo_ins: id_tipo_ins},
        success: function (response) {
            $('#id_ip').html(response);
            $('#id_ip').selectpicker();
            $('#id_ip').selectpicker('refresh');
        },
        error: function () {
            $('#id_ip').html('There was an error!');
        }
    });
}


// var listar = function() {
//     // 1) Leer filtros
//     var tipo_ip = $("#tipo_ip").val();
//     var id_ip   = $("#id_ip").val();
//     var ifecha  = $("#start").val();
//     var ffecha  = $("#end").val();

//     // variables para cálculos por fila
//     var stock_inicial = 0;
//     var cantt         = 0;
//     var scu           = 0;

//     var stock_entradas = 0,
//         stock_salidas  = 0,
//         stock_final    = 0,
//         medida         = '';

//     let stockCalculado = 0;

//     // 2) Inicializar DataTable
//     $('#table').DataTable({
//         destroy:    true,
//         responsive: true,
//         dom:        "tip",
//         bSort:      false,
//         pageLength: 50,

//         ajax: {
//             method: "POST",
//             url:    $('#url').val() + "informe/inventario_kardex_list",
//             data: {
//                 tipo_ip: tipo_ip,
//                 id_ip:   id_ip,
//                 ifecha:  ifecha,
//                 ffecha:  ffecha
//             },
//             dataSrc: function(json) {
//                 // 3) Calcular y volcar resumen de stock
                

//                 if (json.data.length) {
//                     json.data.forEach(function(campo) {
//                         if (campo.estado === 'a') {
//                             medida          = campo.Medida.ins_med;
                            
//                         }
//                     });
                    
//                 } else {
//                     $('.stock-inicial, .stock-entradas, .stock-salidas, .stock-final')
//                         .html('0.0000');
//                 }

//                 // 4) Fusionar kardex + ventas
//                 var data      = json.data.slice(); // copia de movimientos
//                 var ventasRow = json.ventas.map(function(v) {

//                     const perUnit = Number(v.cantidad_insumo_por_unidad) || 0;
//                     const sold    = Number(v.cantidad_vendida) || 0;
//                     const qty = (perUnit > 0) ? (perUnit * sold) : sold;

//                     return {
//                         fecha_r:           v.fecha_venta,
//                         id_tipo_ope:       2,              // como venta
//                         id_ope:            v.id_venta,
//                         id_tipo_ins:       tipo_ip,
//                         id_ins:            id_ip,
//                         cos_uni:           0,
//                         cant:              qty,
//                         cantidad_entrada:  0,
//                         costo_entrada:     0,
//                         total_entrada:     0,
//                         cantidad_salida:   qty,
//                         costo_salida:      v.total,
//                         total_salida:      v.total,
//                         cantidad_vendida : v.cantidad_vendida,
//                         Stock:             false,
//                         Medida:            { ins_med: medida },
//                         Precio:            { cos_pro: v.total },
//                         Comp: {
//                             ser_doc: v.serie_doc,
//                             nro_doc: v.nro_doc,
//                             desc_td: 'Venta'
//                         },
//                         estado: 'a'
//                     };
//                 });
//                 return data.concat(ventasRow);
                
//             }
//         },

//         columns: [
//             {
//                 data: "fecha_r",
//                 render: function(data) {
//                     return '<i class="ti-calendar"></i> ' +
//                         moment(data).format('DD-MM-Y') +
//                         '<br><span class="font-12"><i class="ti-time"></i> ' +
//                         moment(data).format('h:mm A') +
//                         '</span>';
//                 }
//             },
//             {
//                 data: null,
//                 render: function(d) {
                    
//                     var label = d.estado == 'a' ? '' : '<span class="label label-danger">ANULADO</span>';
//                     var cls   = d.estado == 'a' ? '' : 'text-danger';
//                     if (d.id_tipo_ope == 1) {
//                         return 'ENTRADA, POR COMPRA. ' + label +
//                             '<br><span class="font-12 ' + cls + '">' +
//                             d.Comp.desc_td + ' ' + d.Comp.ser_doc + '-' + d.Comp.nro_doc +
//                             '</span>';
//                     }
//                     if (d.id_tipo_ope == 2) {
//                         return 'SALIDA, POR VENTA. ' + label +
//                             '<br><span class="font-12 ' + cls + '">' +
//                             d.Comp.desc_td + ' ' + d.Comp.ser_doc + '-' + d.Comp.nro_doc +
//                             '</span>';
//                     }
//                     if (d.id_tipo_ope == 3) {
//                         return 'ENTRADA, POR AJUSTE DE STOCK. ' + label +
//                             '<br><span class="font-12 ' + cls + '">Responsable: ' +
//                             d.Comp.responsable + ', ' + d.Comp.motivo +
//                             '</span>';
//                     }
//                     if (d.id_tipo_ope == 4) {
//                         return 'SALIDA, POR AJUSTE DE STOCK. ' + label +
//                             '<br><span class="font-12 ' + cls + '">Responsable: ' +
//                             d.Comp.responsable + ', ' + d.Comp.motivo +
//                             '</span>';
//                     }
//                 }
//             },
//             {
//                 data: "cantidad_entrada",
//                 className: "text-success text-left",
//                 render: d => d == 0 ? '-' : d
//             },
//             {
//                 data: "costo_entrada",
//                 render: d => d == 0 ? '-' : formatNumber(d)
//             },
//             {
//                 data: "total_entrada",
//                 render: d => d == 0 ? '-' : d
//             },
//             {
//                 data: "cantidad_salida",
//                 className: "text-danger text-left",
//                 render: d => d == 0 ? '-' : d
//             },
//             {
//                 data: "costo_salida",
//                 render: d => d == 0 ? '-' : formatNumber(d)
//             },
//             {
//                 data: "total_salida",
//                 render: d => d == 0 ? '-' : formatNumber(d)
//             },
//             {
//                 data: null,
//                 render: function(d) {
//                     stockCalculado = d.id_tipo_ope == 3 ? parseFloat(stockCalculado) + parseFloat(d.cant) : stockCalculado - d.cant;
//                     return '<div class="text-info text-center">' +
//                         parseFloat(stockCalculado) +
//                         '</div>';
//                 }
//             },
//             {
//                 data: null,
//                 render: function(d) {
//                     scu = ([1,3].includes(d.id_tipo_ope) ? d.cos_uni : d.Precio.cos_pro);
//                     return formatNumber(scu);
//                 }
//             },
//             {
//                 data: null,
//                 render: function(d) {
//                     var totalFila = d.id_tipo_ope == 3 ? parseFloat(d.total_entrada) :  parseFloat(d.total_salida);
//                     return '<div class="font-medium text-center">' +
//                         parseFloat(totalFila) +
//                         '</div>';
//                 }
//             }
//         ],

//         footerCallback: function(row, data, start, end, display) {
            
//             data.forEach(function(item) {
//                 if (item.id_tipo_ope == 3) {
//                     stock_inicial += parseFloat(item.cant);
//                     stock_entradas += parseFloat(item.cant);
                    
                    
//                 } else {
//                     stock_salidas  += parseFloat(item.cant);
//                 }

//             });

//             stock_final    = stock_entradas - stock_salidas;

//             $('.stock-inicial').html(stock_inicial.toFixed(4) + ' <sup>' + medida + '</sup>');
//             $('.stock-entradas').html(stock_entradas.toFixed(4) + ' <sup>' + medida + '</sup>');
//             $('.stock-salidas').html(stock_salidas.toFixed(4) + ' <sup>' + medida + '</sup>');
//             $('.stock-final').html(stock_final.toFixed(4) + ' <sup>' + medida + '</sup>');
            
//         }
//     });
// };


var listar = function () {
  // 1) Leer filtros
  var tipo_ip = $("#tipo_ip").val();
  var id_ip   = $("#id_ip").val();
  var ifecha  = $("#start").val();
  var ffecha  = $("#end").val();

  // 2) Inicializar DataTable
  $('#table').DataTable({
    destroy:    true,
    responsive: true,
    dom:        "tip",
    bSort:      false,
    pageLength: 50,
    processing: true,

    ajax: {
      method: "POST",
      url:    $('#url').val() + "informe/inventario_kardex_list",
      data:   { tipo_ip: tipo_ip, id_ip: id_ip, ifecha: ifecha, ffecha: ffecha },

      // Como tu API devuelve { ok: true, data: [...] } usamos la clave "data"
      dataSrc: 'data',

      error: function (xhr, status, err) {
        console.error('DT ajax error:', status, err, xhr?.responseText);
      }
    },

    columns: [
      // Fecha de registro
      {
        data: "fecha_registro",
        defaultContent: null,
        render: function (val) {
          if (!val) return '-';
          // Asegura YYYY
          return '<i class="ti-calendar"></i> ' +
                 moment(val).format('DD-MM-YYYY') +
                 '<br><span class="font-12"><i class="ti-time"></i> ' +
                 moment(val).format('h:mm A') +
                 '</span>';
        }
      },

      // Descripción / concepto
      {
        data: null,
        defaultContent: null,
        render: function (row) {
          const activo = (row.estado === 'activo' || row.estado === 'a');
          const label  = activo ? '' : '<span class="label label-danger">ANULADO</span>';
          const cls    = activo ? '' : 'text-danger';

          const esVenta = (row.tipo_kardex === 'venta' || row.tipo_kardex === 'salidas');
          const docTxt  = esVenta
            ? `${row.serie_documento || ''}-${row.numero_documento || ''}`
            : '-';

          const concepto = row.concepto || (esVenta ? 'SALIDA, POR VENTA.' : 'MOVIMIENTO');

          return `${concepto} ${label}<br><span class="font-12 ${cls}">${docTxt}</span>`;
        }
      },

      // Entrada: cantidad
      {
        data: "cantidad_entrada",
        className: "text-success text-left",
        defaultContent: 0,
        render: function (v, t, row) {
          const esIngreso = (row.tipo_kardex === 'ingresos' || row.tipo_kardex === 'entrada' || row.tipo_kardex === 'ajuste_entrada');
          const val = parseFloat(v || 0);
          return esIngreso && val !== 0 ? val : '-';
        }
      },

      // Entrada: costo unitario
      {
        data: "costo_unitario",
        defaultContent: 0,
        render: function (v, t, row) {
          const esIngreso = (row.tipo_kardex === 'ingresos' || row.tipo_kardex === 'entrada' || row.tipo_kardex === 'ajuste_entrada');
          const n = parseFloat(v || 0);
          return esIngreso && n !== 0 ? formatNumber(n) : '-';
        }
      },

      // Entrada: costo total
      {
        data: "costo_total",
        defaultContent: 0,
        render: function (v, t, row) {
          const esIngreso = (row.tipo_kardex === 'ingresos' || row.tipo_kardex === 'entrada' || row.tipo_kardex === 'ajuste_entrada');
          const n = parseFloat(v || 0);
          return esIngreso && n !== 0 ? formatNumber(n) : '-';
        }
      },

      // Salida: cantidad
      {
        data: "cantidad_salida",
        className: "text-danger text-left",
        defaultContent: 0,
        render: function (v, t, row) {
          const esVenta = (row.tipo_kardex === 'venta' || row.tipo_kardex === 'salidas' || row.tipo_kardex === 'ajuste_salida');
          const val = parseFloat(v || 0);
          return esVenta && val !== 0 ? val : '-';
        }
      },

      // Salida: costo unitario
      {
        data: "costo_unitario",
        defaultContent: 0,
        render: function (v, t, row) {
          const esVenta = (row.tipo_kardex === 'venta' || row.tipo_kardex === 'salidas' || row.tipo_kardex === 'ajuste_salida');
          const n = parseFloat(v || 0);
          return esVenta && n !== 0 ? formatNumber(n) : '-';
        }
      },

      // Salida: costo total
      {
        data: "costo_total",
        defaultContent: 0,
        render: function (v, t, row) {
          const esVenta = (row.tipo_kardex === 'venta' || row.tipo_kardex === 'salidas' || row.tipo_kardex === 'ajuste_salida');
          const n = parseFloat(v || 0);
          return esVenta && n !== 0 ? formatNumber(n) : '-';
        }
      },

      // Stock (el render recibe el VALOR, no el objeto)
      {
        data: "stock",
        defaultContent: 0,
        render: function (value) {
          const n = parseFloat(value ?? 0);
          return `<div class="text-info text-center">${isNaN(n) ? '0.0000' : n.toFixed(4)}</div>`;
        }
      },

      // Columna extra (si la necesitas, aquí muestro el costo unitario general)
      {
        data: "costo_unitario",
        defaultContent: 0,
        render: function (v) {
          const n = parseFloat(v || 0);
          return n ? formatNumber(n) : formatNumber(0);
        }
      },

      // Total fila (general)
      {
        data: "costo_total",
        defaultContent: 0,
        render: function (v) {
          const n = parseFloat(v || 0);
          return '<div class="font-medium text-center">' + (n ? formatNumber(n) : '0') + '</div>';
        }
      }
    ],

    footerCallback: function (row, data) {
      // Calcula totales simples con tus campos actuales (string numérico)
      let stock_inicial   = 0; // Si necesitas saldo antes del rango, debe venir del backend
      let stock_entradas  = 0;
      let stock_salidas   = 0;
      let stock_final     = 0;

      data.forEach(item => {
        stock_entradas += parseFloat(item.cantidad_entrada || 0);
        stock_salidas  += parseFloat(item.cantidad_salida  || 0);
      });

      stock_final = stock_entradas - stock_salidas;

      $('.stock-inicial').html(stock_inicial.toFixed(4));
      $('.stock-entradas').html(stock_entradas.toFixed(4));
      $('.stock-salidas').html(stock_salidas.toFixed(4));
      $('.stock-final').html(stock_final.toFixed(4));
    }
  });
};
