<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Incluimos nuestro archivo de conexin
// Asegrate de que la ruta a 'conexion.php' sea correcta desde este archivo.
require_once 'conexion.php';

$sql = "
  SELECT
    pres.id_pres,  -- Este es el ID real
    pres.presentacion,
    pres.precio,
    pres.descripcion,
    pres.imagen AS archivo_imagen,
    prod.nombre AS nombre_producto,
    catg.descripcion AS categoria
  FROM tm_producto_pres pres
  INNER JOIN tm_producto prod
    ON pres.id_prod = prod.id_prod
  INNER JOIN tm_producto_catg catg
    ON prod.id_catg = catg.id_catg
  WHERE pres.estado = 'a'
    AND prod.estado = 'a'
    AND catg.estado = 'a'
    AND pres.delivery = 1
  ORDER BY catg.orden, prod.nombre, pres.ordenins
";

$result = mysqli_query($conn, $sql);
if (!$result) {
    echo json_encode(["error" => "Error en la consulta de productos: " . mysqli_error($conn)]);
    mysqli_close($conn);
    exit;
}

$data = [];
while ($row = mysqli_fetch_assoc($result)) {
    // AHORA NO CAMBIAMOS EL NOMBRE, simplemente pasamos el id_pres
    $data[] = $row;
}

mysqli_close($conn);
echo json_encode($data);
?>